@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                <h4>Providers</h4>
                </div>

                <!-- <div class="card-body">
                    @if (session('status'))
                        <div class="alert alert-success" role="alert">
                            {{ session('status') }}
                        </div>
                    @endif

                    {{ __('You are logged in!') }}


                    
                </div> -->
            </div>

           
            
            <table class="table table-striped table-bordered">
            <thead class="table-dark">
                <tr>
                <th scope="col">#</th>
                <th scope="col">Name</th>
                <th scope="col">Mobile</th>
                <th scope="col">Service</th>
                <th scope="col">Status</th>
                </tr>
            </thead>
            <tbody>
                @foreach($providers as $index => $provider)
                    <tr>
                        <td>{{ $provider->id }}</td>
                        <td>{{ $provider->name }}</td>
                        <td>{{ $provider->mobile }}</td>
                        <td>{{ $provider->myService->name_ar ?? 'No service' }}</td>
                        <td>
                            <!-- {{ $provider->status }} -->
                            <form action="/providers" method="POST">
                                @csrf
                                <div class="d-flex align-items-center gap-2">
                                    <select name="status" class="form-select">

                                        <option value="pending" {{ $provider->status == 'pending' ? 'selected' : '' }}>Pending</option>
                                        <option value="approved" {{ $provider->status == 'approved' ? 'selected' : '' }}>Approved</option>
                                        <option value="rejected" {{ $provider->status == 'rejected' ? 'selected' : '' }}>Rejected</option>


                                    </select>
                                    <input type="hidden" name="provider_id" value="{{ $provider->id }}">
                                    <button type="submit" class="btn btn-primary">
                                        Update
                                    </button>
                                </div>
                            </form>
                        </td>
                        <!-- <td>
                            <button class="btn btn-sm btn-primary">Edit</button>
                            <button class="btn btn-sm btn-danger">Delete</button>
                        </td> -->
                    </tr>
                @endforeach
                <!-- More rows here -->
            </tbody>
            </table>




            
        </div>
    </div>
</div>
@endsection
