<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('appointments', function (Blueprint $table) {
            $table->id();
            $table->string('mobile');
            $table->string('name');
            $table->integer('service');
            $table->integer('provider');
            $table->timestamp('date')->nullable();
            $table->string('status')->default('pending');
            $table->decimal('price',9,3)->default(0);
            $table->decimal('cost_provider',9,3)->default(0);
            $table->decimal('net_profit',9,3)->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('appointments');
    }
};
