<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Appointment extends Model
{
    /** @use HasFactory<\Database\Factories\AppointmentFactory> */
    use HasFactory;
    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'mobile',
        'name',
        'service',
        'provider',
        'date',
        'status',
        'price',
        'cost_provider',
        'net_profit',
    ];

    public function myService()
    {
        return $this->belongsTo(Service::class, 'service');
    }

    public function myProvider()
    {
        return $this->belongsTo(Provider::class, 'provider');
    }
}
